package cn.com.duiba.tuia.purchase.web.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author ikongyi && zhongda
 */
@Getter
@Setter
public class MediaConfigDto implements Serializable {
    private static final long serialVersionUID = -1L;


    protected Long id;

    /**
     * 媒体平台ID
     */

    private Long mediaPlatformId;

    /**
     * 媒体平台名称
     */

    private String mediaPlatformName;

    /**
     * 代理名称
     */

    private String agentName;

    /**
     * 媒体ID
     */

    private Long mediaAppId;

    /**
     * 媒体名称
     */

    private String mediaAppName;

    /**
     * 投放产品ID
     */
    private Long productId;

    /**
     * 投放产品名称
     */

    private String productName;

    /**
     * 媒体返点（百分点）
     */

    private BigDecimal rebateRate;

    /**
     * 运营负责人
     */

    private List<Long> managerIds;

    /**
     * 备注
     */

    private String remark;

    /**
     * 结算方式
     */
    private String billingMethod;

    /**
     * 媒体返点
     */
    private BigDecimal mediaRebateRate;

    /**
     * 媒体分成
     */
    private BigDecimal mediaDivideRate;
}
