package cn.com.duiba.tuia.purchase.web.api.dto;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 产品任务
 */
@Data
@SuppressWarnings("serial")
public class TaskDto implements Serializable {
    private static final long serialVersionUID = -1L;

    protected Long id;
    /**
     * 创建时间
     **/
    protected Date gmtCreate;
    /**
     * 修改时间
     **/
    protected Date gmtModified;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 产品id
     **/
    private Long productId;
    /**
     * 产品名称
     **/
    private String productName;
    /**
     * 产品标示
     **/
    private String productCode;
    /**
     * 广告主Id(tuia_adver.accout表主键的外键)
     **/
    private Long advertiserId;
    /**
     * 广告主名称
     **/
    private String advertiserName;
    /**
     * 媒体平台id
     **/
    private Long mediaPlatformId;
    /**
     * 媒体平台名称
     **/
    private String mediaPlatformName;
    /**
     * 曝光监测链接
     **/
    private String exposureLink;
    /**
     * 点击监测链接
     **/
    private String clickLink;
    /**
     * CPS任务Code
     */

    private String cpsTaskCode;

    /**
     * 结算方式
     */
    private String billingMethod;

    /**
     * 媒体返点
     */
    private BigDecimal mediaRebateRate;

    /**
     * 媒体分成
     */
    private BigDecimal mediaDivideRate;

    /**
     * 日报链接
     */
    private String dailyUrl;

    /**
     * 在投账户id
     */
    private String investmentAccountIds;

}
