package cn.com.duiba.tuia.purchase.web.api.dto;

import cn.com.duiba.tuia.purchase.web.api.model.query.BaseQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2023/9/5.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TuiaDailyPageDto extends BaseQuery implements Serializable {
    private static final long serialVersionUID = -4674267021363904197L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 统计日期
     */
    private Date statisticsDate;

    /**
     * 产品标识
     */
    private Long productId;

    /**
     * 媒体账户id
     */
    private Long accountId;

    /**
     * 展示次数
     */
    private Integer impressions;

    /**
     * 点击次数
     */
    private Integer clicks;

    /**
     * 消耗金额
     */
    private BigDecimal cost;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 媒体id
     */
    private Long mediaId;

    /**
     * 任务ids
     */
    private List<Long> taskIds;

    private Date startDate;

    private Date endDate;
}
