package cn.com.duiba.tuia.purchase.web.api.model;

import cn.com.duiba.tuia.purchase.web.api.constant.MediaCallbackStrategyConsts;
import cn.com.duiba.tuia.purchase.web.api.dto.PbpMediaCallbackStrategyDto;
import lombok.Data;

import java.util.Collections;
import java.util.List;

/**
 * @author zhongda & ikongyi
 */
@Data
public class PbpEventCallbackStrategyContext {

    private static final List<Integer> ASYNC_CALLBACK_STRATEGY_LIST = Collections.singletonList(MediaCallbackStrategyConsts.StrategyType.TYPE_AMOUNT);

    /**
     * 渠道ID（任务ID）
     */
    private Long channelId;

    /**
     * 计划ID
     */
    private Long planId;

    /**
     * 推啊数据类型
     */
    private String aEventType;

    /**
     * 媒体数据类型
     */
    private String mEventType;

    /**
     * <pre>
     * 是否需要进行回传：<code>true</code> 是
     *               <code>false</code> 否
     * </pre>
     */
    private Boolean shouldCallback = Boolean.FALSE;

    private Long strategyId;

    /**
     * 回传策略类型
     * @see MediaCallbackStrategyConsts.StrategyType
     */
    private Integer strategyType;
    /**
     * 是否需要打印日志
     */
    private Boolean needPrintLog;

    /**
     * 回传策略规则
     */
    private PbpMediaCallbackStrategyDto.StrategyContent strategyRule;

    /**
     * <pre>
     *     是否异步回传媒体数据：<code>true</code> 是
     *                       <code>false</code> 否
     * </pre>
     * <pre>
     *     同步回传的策略类型：
     *                      概率回传
     *     异步回传的策略类型：
     *                      按收益回传
     * </pre>
     */
    public boolean isAsyncCallback() {
        return ASYNC_CALLBACK_STRATEGY_LIST.contains(strategyType);
    }

}
