package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.EngineFieldDto;
import cn.com.duiba.tuia.risk.center.api.dto.RpsEngineFieldDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.EngineFieldParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqEngineField;

import java.util.List;

/**
 * 规则引擎字段信息服务 ClassName: RemoteEngineFieldService <br/>
 * date: 2018年7月23日 下午6:45:20 <br/>
 * .
 *
 * @author lijian
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteEngineFieldService {

    /**
     * @Description: 分页查询规则引擎字段信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    PageResultDto<RpsEngineFieldDto> queryPage(EngineFieldParam param);

    /**
     * @Description: 新增规则引擎字段信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer save(ReqEngineField dto);

    /**
     * @Description: 更新规则引擎字段信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer update(ReqEngineField dto);

    /**
     * @Description: 删除规则引擎字段信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer delete(EngineFieldDto dto);

    /**
     * @Description: 校验除了当前关联的场景，是否还有重复的字段名称
     * @Param:
     * @return:  ture 为不重复
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Boolean checkFieldByScene(ReqEngineField req);

    /**
     * @Description: 根据场景id查询字段信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    List<EngineFieldDto> getFieldBySceneId(Long sceneId);

}
