package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AdvertInspectDto;
import cn.com.duiba.tuia.risk.center.api.dto.AdvertSecondReviewDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.InspectSearchParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.SecondReviewSearchParam;

/**
 * 广告复审service
 */
@AdvancedFeignClient
public interface RemoteAdvertReviewService {

	// 复审列表
	PageResultDto<AdvertSecondReviewDto> queryPage(SecondReviewSearchParam param);

	Boolean canSecondReview(List<Long> ids);

	// 复审
	int secondReview(List<Long> ids, Integer result, String reviewer, String memo);

	PageResultDto<AdvertInspectDto> queryInspectPage(InspectSearchParam param);

	Boolean canInspect(List<Long> ids);

	Boolean canDown(List<Long> ids);

	int inspect(List<Long> ids, Integer result, String reviewer, String memo);
}
