package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class RiskSlotReviewDto implements Serializable {

    private static final long serialVersionUID = -4734538431826278350L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("巡查时间")
    private Date reviewTime;

    @ApiModelProperty("资源审核状态 0-待审核 1-拒绝 2-通过")
    private Integer reviewStatus;

    @ApiModelProperty("上次OSS URL")
    private String lastUrl;

    @ApiModelProperty("本次OSS URL")
    private String currentUrl;

    @ApiModelProperty("差异度")
    private Integer diff;

    @ApiModelProperty("对比的上次巡查时间")
    private Date lastReviewTime;

    @ApiModelProperty("图片P哈希值")
    private String hashDegree;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public String getLastUrl() {
        return lastUrl;
    }

    public void setLastUrl(String lastUrl) {
        this.lastUrl = lastUrl;
    }

    public String getCurrentUrl() {
        return currentUrl;
    }

    public void setCurrentUrl(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public Integer getDiff() {
        return diff;
    }

    public void setDiff(Integer diff) {
        this.diff = diff;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getLastReviewTime() {
        return lastReviewTime;
    }

    public void setLastReviewTime(Date lastReviewTime) {
        this.lastReviewTime = lastReviewTime;
    }

    public String getHashDegree() {
        return hashDegree;
    }

    public void setHashDegree(String hashDegree) {
        this.hashDegree = hashDegree;
    }
}
