package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 风控广告位&媒体白名单
 */
@ApiModel
public class SlotMediaWhiteDto implements Serializable {

    private static final long serialVersionUID = 5638586913456739628L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("名单维度 0-广告位, 1-媒体")
    @NotNull(message = "名单维度为null")
    private Integer dimension;

    @ApiModelProperty("场景类型 0-作弊验证场景 1-作弊媒体钟馗同步场景")
    @NotNull(message = "场景类型为null")
    private Integer sceneType;

    @ApiModelProperty("名单值")
    @NotNull(message = "名单值为null")
    private Long rosterVal;

    @ApiModelProperty("名单名称")
    private String rosterName;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("备注")
    private String description;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setRosterVal(Long rosterVal) {
        this.rosterVal = rosterVal;
    }

    public Long getRosterVal() {
        return rosterVal;
    }

    public void setRosterName(String rosterName) {
        this.rosterName = rosterName;
    }

    public String getRosterName() {
        return rosterName;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return creator;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}

