package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompeteDomainPatrolDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompeteDomainPatrolParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCompeteDomainPatrolService {

    PageResultDto<CompeteDomainPatrolDto> queryPage(CompeteDomainPatrolParam param);

    int save(CompeteDomainPatrolDto dto);

    int update(CompeteDomainPatrolDto dto);

    int deleteById(Long id);

    /**
     * 获取已保存的竞品名称列表
     */
    List<String> getAllCompeteNames();

    /**
     * 获取已保存的媒体名称列表
     */
    List<String> getAllMediaNames();

    /**
     * 情报系统竞品域名巡查任务
     */
    void competeDomainPatrolProcess();
}
