package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskIndustryWordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskIndustryWordService {

    /**
     * @Description: 查询某个行业关键词的数量
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer getInfoIndustryWord(String industryName, String wordName);

    /**
     * @Description: 新增情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer save(RiskIndustryWordDto dto);

    /**
     * @Description: 更新情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer updateByParam(RiskIndustryWordDto dto);


    /**
     * @Description: 删除情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer deleteById(Long id);

    /**
     * @Description: 获取所有的行业列表
     * @Author: lijian
     * @Date: 2019/5/16
     */
    List<String> getIndustrys();

    /**
     * @Description: 分页查询情报系统行业关键词信息
     * @Author: lijian
     * @Date: 2019/3/21
     */
    PageResultDto<RiskIndustryWordDto> queryPage(ReqPageQuery param);


    RiskIndustryWordDto getById(Long id);


}
