/**
 * 
 */
package cn.com.duiba.tuia.risk.center.api.constant;

/**
 * 此类描述的是： 推啊活动中心工程内部自定义错误码规范<br>
 * 错误码组成：AABBCCC
 * <ul>
 * AA：模块编号
 * <li>00：公共模块</li>
 * <li>01：活动模块</li>
 * <li>02：订单模块</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 应用级错误（参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）</li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）</li>
 * </ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：000</li>
 * <li>通用的未知错误码：999</li>
 * </ul>
 * <ul>
 * 业务前缀
 * <li>tuia-activity-center：TAC_</li>
 * </ul>
 * 
 * @规范： http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @汇总文档：http://cf.dui88.com/pages/viewpage.action?pageId=3560274
 */
public enum ErrorCode {

    // 公共模块00
    /** 成功. */
    E0000000("0000000", "成功"),

    /** 未知错误. */
    E9999999("9999999", "未知错误"),

    /** 数据库错误. */
    E0002001("0002001", "数据库错误"),

    /**参数为空. */
    E0001002("0001002", "参数为空"),

    /** 参数异常. */
    E0001003("0001003", "参数异常"),
    
    /** 请求数据过大.*/
    E0001004("0001004","数据量过大"),
    
    /** 获取虚拟商品普通券失败.*/
    E0001005("0001005","获取虚拟商品普通券失败"),
    /** 获取分布式锁失败.*/
    E0001006("0001006","获取分布式锁失败"),

    // 活动模块01
    E0102001("0102001","奖品不存在"),

    E0102002("0102002","奖品已删除"),

    E0102003("0102003","奖品已用完"),

    E0102004("E0102004","奖品已关闭"),

    E0102005("E0102005","奖品已过期"),

    /* 直投页零钱奖励配置异常 */
    E0102006("0102006", "零钱奖励配置不存在"),

    /** 库存中心异常. */
    E0103004("0103004", "库存中心异常"),

    E0103005("0103005", "库存id未设置"),
    /** 虚拟商品券库为空 */
    E0103006("0103006", "虚拟商品券库为空"),

    E0103007("0103007", "获取不到批次"),

    E0103008("0103008", "库存不足"),




    // 订单模块02
    E0200001("0200001", "该订单不能发起支付宝转账"),
    E0200002("0200002", "推啊订单异常,请稍后再看"),
    E0200003("0200003", "支付宝转账结果未知"),
    E0200004("0200004", "您的支付宝账号信息错误,请检查重填"),
    E0200005("0200005", "您的支付宝账号不支持转账,请确认"),
    E0200006("0200006", "您已领取过,不要贪心哦"),
    E0200007("0200007", "支付宝转账异常，请稍后再试"),


    E0200010("0200010", "移动临时用户中奖数据出现异常"),
    E0200011("0200011", "账户不存在"),
    E0200012("0200012", "钱包账户余额不足"),
    E0200013("0200013", "付款方余额不足"),




    E0300001("0300001", "该订单不能发起QB充值"),
    E0300002("0300002", "推啊订单异常,请稍后再看"),
    E0300003("0300003", "QB充值结果未知"),
    E0300004("0300004", "输入有误，请检查QQ号是否正确"),
    E0300005("0300005", "充值中.请稍等"),
    ;

    /** 错误码. */
    private String code;

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param code the error code
     * @param desc the desc
     */
    ErrorCode(String code, String desc) {
        this.code = "TA-" + code;
        this.desc = desc;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return code;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
