package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.DashBoardResult;
import cn.com.duiba.tuia.risk.center.api.dto.RiskDashBoardDetailDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.DashBoardParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqRiskDashBoardDetail;

/**
 * 提供给媒体管理端, 反馈最终分成比例
 */
@AdvancedFeignClient
public interface RemoteRiskDashBoardDetailService {
    /**
     * @Description: 根据日期查询风险大盘明细数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/6
     */
    List<RiskDashBoardDetailDto> selectByDate(ReqRiskDashBoardDetail req);

    /**
     * @Description: 分页查询风险大盘明细数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/6
     */
    PageResultDto<RiskDashBoardDetailDto> queryPage(ReqRiskDashBoardDetail req);

    List<DashBoardResult> queryBashBoard(DashBoardParam param);

    List<DashBoardResult> queryBashBoardAppTop30(DashBoardParam param);

    /**
     * @Description: 根据id更新风险大盘明细数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/9/6
     */
    int updateById(RiskDashBoardDetailDto dto);
}
