package cn.com.duiba.tuia.risk.center.api.dto.req;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import cn.com.duiba.tuia.risk.center.api.dto.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel
@EqualsAndHashCode(callSuper = true)
@Data
public class SlotStatisParam extends PageParam {
    @ApiModelProperty("开始时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   startTime;
    @ApiModelProperty("结束时间 yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   endTime;
    @ApiModelProperty("广告位id")
    private Long   slotId;
    @ApiModelProperty("媒体id")
    private Long   appId;
    @ApiModelProperty("ip")
    private String ip;
    @ApiModelProperty("ua")
    private String ua;
    @ApiModelProperty("deviceId")
    private String deviceId;
    @ApiModelProperty("城市")
    private String city;
}
