package cn.com.duiba.tuia.risk.center.api.dto.req;

import cn.com.duiba.tuia.risk.center.api.constant.WaveAnalysisSortField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 波动分析
 */
@ApiModel
public class ReqSlotWaveAnalysis extends ReqPageQuery {

    private static final long     serialVersionUID = 1L;

    @ApiModelProperty("对比时段开始时间")
    protected String              conStartTime;

    @ApiModelProperty("对比时段结束时间")
    protected String              conEndTime;

    @ApiModelProperty("广告位ID")
    private Long                  slotId;

    @ApiModelProperty("规则ID")
    private String                ruleId;

    /** 排序字段. */
    @ApiModelProperty("排序字段")
    private WaveAnalysisSortField field;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    @ApiModelProperty("排序方式：(升序:asc,降序：desc)默认降序")
    private String                order;

    public String getConStartTime() {
        return conStartTime;
    }

    public void setConStartTime(String conStartTime) {
        this.conStartTime = conStartTime;
    }

    public String getConEndTime() {
        return conEndTime;
    }

    public void setConEndTime(String conEndTime) {
        this.conEndTime = conEndTime;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public WaveAnalysisSortField getField() {
        return field;
    }

    public void setField(WaveAnalysisSortField field) {
        this.field = field;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}
