/**
 * Project Name:activity-center-biz<br>
 * File Name:SystemConfigService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.biz.service<br>
 * Date:2017年1月16日下午6:45:20<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.risk.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.SystemConfigDto;

import java.util.List;

/**
 * 配置项服务 ClassName: SystemConfigService <br/>
 * date: 2017年1月16日 下午6:45:20 <br/>
 * .
 *
 * @author youhaijun
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteSystemConfigService {

    /**
     * 根据配置项KEY查询配置项的值.
     *
     * @param configKey the  key
     * @return the string
     */
    List<String> selectByKey(String configKey);

    /**
     * updateByKey:(根据key 更新). <br/>
     *
     * @param configKey
     * @param configValue
     * @return boolean
     */
    boolean updateByKey(String configKey, String configValue);

    boolean updateOrInsert(String configKey, String configValue, String desc);

    /**
     * getConfigByKey:(根据key查询配置). <br/>
     *
     * @param configKey
     * @return String
     */
    List<SystemConfigDto> getConfigByKey(String configKey);

    /**
     * 根据配置项id删除配置项.
     *
     * @param id id
     * @return the string
     */
    Boolean deleteById(Long id);

    boolean add(String configKey, String configValue, String desc);

    /**
     * 根据key 和value 查询数据
     *
     * @param configKey
     * @param configValue
     * @return
     */
    String getConfigByKeyAndVal(String configKey, String configValue);
}
