package cn.com.duiba.tuia.risk.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.domain.DomainDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.PagingDomainParam;

/**
 * 域名服务
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDomainService {

    /**
     * 域名分页查询
     *
     * @param pagingDomainParam  查询参数
     * @return
     */
    PageResultDto<DomainDTO> pagingList(PagingDomainParam pagingDomainParam);

    /**
     * 添加域名
     *
     * @param domainDTO      域名参数
     * @throws  BizException
     * @return
     */
    boolean addDomain(DomainDTO domainDTO) throws BizException;

    /**
     * 删除域名
     *
     * @param  id   域名记录id
     * @return
     * @throws BizException
     */
    boolean deleteDomain(Long id) throws BizException;

    /**
     * 根据域名类型查询有效域名列表
     *
     * @param domainType  域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    List<String> selectValidDomainByType(Integer domainType);

    /**
     * 查询给微信巡查的域名列表
     *
     * @return
     */
    List<String> selectWxPatrol();

}
