package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Api("风控拦截发券数据表")
public class RiskCheatStopDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("当天日期")
    private Date curDate;

    @ApiModelProperty("拦截发券PV")
    private Long stopLaunchPv;

    @ApiModelProperty("未拦截发券PV")
    private Long unstopLaunchPv;

    @ApiModelProperty("拦截发券PV率=拦截发券PV/(拦截发券PV+为拦截发券PV)")
    private BigDecimal stopLaunchRate;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setStopLaunchPv(Long stopLaunchPv) {
        this.stopLaunchPv = stopLaunchPv;
    }

    public Long getStopLaunchPv() {
        return stopLaunchPv;
    }

    public void setUnstopLaunchPv(Long unstopLaunchPv) {
        this.unstopLaunchPv = unstopLaunchPv;
    }

    public Long getUnstopLaunchPv() {
        return unstopLaunchPv;
    }

    public void setStopLaunchRate(BigDecimal stopLaunchRate) {
        this.stopLaunchRate = stopLaunchRate;
    }

    public BigDecimal getStopLaunchRate() {
        return stopLaunchRate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

