package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 域名状态
 *
 * @author peanut.huang
 * @date 2019/10/25
 * @since JDK 1.8
 */
public enum DomainStatusEnum {

    /**
     *
     */
    INVALID(0, "失效"),

    VALID(1, "正常")

    ;

    /**
     * 状态值
     */
    private Integer status;

    /**
     * 描述
     */
    private String  desc;


    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }


    DomainStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return
     */
    static DomainStatusEnum findByStatus(Integer status){
        if(status == null){
            return null;
        }
        return Stream.of(DomainStatusEnum.values()).filter(e -> Objects.equals(e.getStatus(), status)).findFirst().orElse(null);
    }
}
