package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.CheatAppHandleDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.CheatAppHandleParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCheatAppHandleService {

    /**
     * 查询广告位列表
     * @param param
     * @return
     */
    List<CheatAppHandleDto> list(CheatAppHandleParam param);

    /**
     * 新增广告位
     * @param param
     */
    void insert(CheatAppHandleParam param);


    /**
     * 编辑广告位
     * @param param
     */
    void edit(CheatAppHandleParam param);


    /**
     * 删除广告位
     * @param id
     */
    void delete(Long id);


    /**
     * 导出广告位列表
     * @param param
     */
    void export(CheatAppHandleParam param);


    /**
     * 查询arup趋势
     * @param param
     * @return
     */
    List<CheatAppHandleDto> arupList(CheatAppHandleParam param);


    /**
     * 获取问题类型
     */
    List<String> getQuestType();
}
