package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
public class SlotCheatInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long appId;
    private Long dwsId;
    private Long slotId;
    private Integer cheatGrade;
    private BigDecimal adConsume;
    private BigDecimal cheatFee;
    private Integer todayRate;
    private Integer adviceRate;
    private Integer handleResult;
    private Integer finalRate;
    private BigDecimal finalDealMoney;
    private Date curDate;
    // 作弊消耗占比=作弊消耗/消耗
    private Double cheatFeeRate;
    /**
     * 媒体当日消耗
     */
    private Long appAdConsume;
    /**
     * 分成方式  结算方式:0-分成;1-CPC;2-CPM
     */
    private Integer settleMethod;

    // 风控建议分成比例=[（消耗-作弊消耗）*B]/消耗
    public Integer calAdviceRate() {
        log.info("cal advice rate - " + this);
        try {
            adviceRate = adConsume.subtract(cheatFee).multiply((new BigDecimal(todayRate))).divide(adConsume, 0,
                    BigDecimal.ROUND_HALF_DOWN).intValue();
        } catch (Exception e) {
            log.error(e.getMessage());
            adviceRate = 0;
        }
        return adviceRate;
    }

    //// 当媒体处理意见为不同意时，最终处理金额=作弊消耗-消耗*（最终分成比例-建议分成比例）
    public BigDecimal calfinalDealMoney() {
        log.info("cal finalDealMoney - " + this);
        try {
            finalDealMoney = cheatFee.subtract(adConsume.multiply(new BigDecimal(finalRate).subtract(new BigDecimal(adviceRate))).divide(new BigDecimal(10000),
                    2,
                    BigDecimal.ROUND_HALF_DOWN));
        } catch (Exception e) {
            log.error(e.getMessage());
            finalDealMoney = BigDecimal.ZERO;
        }
        return finalDealMoney;
    }
}
