package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AdvertWhiteListDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.AdvertWhiteListParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertWhiteListService {

    /**
     * @Description: 分页查询广告计划白名单信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/06
     */
    PageResultDto<AdvertWhiteListDto> queryPage(AdvertWhiteListParam params);

    /**
     * @Description: 保存广告计划白名单信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/06
     */
    Boolean save(AdvertWhiteListDto dto);

    /**
     * @Description: 根据id删除广告计划白名单
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/06
     */
    Boolean deleteById(Long id);

    /**
     * @Description: 根据条件查询白名单是否存在
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/06
     */
    Boolean getCountByParam(AdvertWhiteListDto dto);

    /**
     * 根据条件查询所有符合条件的数据
     */
    List<AdvertWhiteListDto> query(AdvertWhiteListParam params);

}
