package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.SlotMediaWhiteDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.MediaWhiteListParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSlotMediaWhiteService {

    /**
     * @Description: 分页查询广告位&媒体白名单信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    PageResultDto<SlotMediaWhiteDto> queryPage(MediaWhiteListParam param);

    /**
     * @Description: 保存广告位&媒体白名单信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    Boolean save(SlotMediaWhiteDto dto);


    /**
     * @Description: 根据id删除广告位&媒体白名单信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    Boolean deleteById(Long id);

    /**
     * @Description: 根据条件判断广告位&媒体白名单是否存在
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    Boolean countByParam(MediaWhiteListParam param);


    /**
     * 根据条件查询所有符合条件的数据
     */
    List<SlotMediaWhiteDto> query(MediaWhiteListParam param);

    /**
     * 查询所有白名单数据
     */
    List<SlotMediaWhiteDto> getAllWhiteList();

}
