package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@ApiModel
public class BlacklistUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @Min(value = 1, message = "id最小值为1")
    private Long id;

    @NotNull(message = "名单值不能为空")
    @Length(max = 56, message = "名单值最大长度为56位")
    @ApiModelProperty("名单值")
    private String val;

    private String valOld;

    @NotNull(message = "风险等级不能为空")
    @Range(min = 0, max = 2, message = "风险等级参数值不在范围内")
    @ApiModelProperty("名单维度 0-低风险, 1-中风险, 2-高风险")
    private Integer riskRank;

    @NotNull(message = "状态不能为空")
    @Range(min = 0, max = 1, message = "状态参数值不在范围内")
    @ApiModelProperty("状态 0-启用 1-禁用")
    private Integer stat;

    @Length(max = 56, message = "来源最大长度为56位")
    @ApiModelProperty("来源")
    private String src;

    @Length(max = 64, message = "备注最大长度为64位")
    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("名单场景 0-推啊广告曝光场景 1-兑吧提现场景")
    @Range(min = 0, max = 10, message = "状态参数值不在范围内")
    private Integer scene;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

    @ApiModelProperty("更新人")
    private String mender;

    @ApiModelProperty("设备标示")
    private String hardWare;

    @ApiModelProperty("设备标示加密")
    private String hardWareMd5;

    @ApiModelProperty("设备标示类型")
    private String hardWareType;

    @ApiModelProperty("udid")
    private String udid;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public Integer getStat() {
        return stat;
    }

    public void setStat(Integer stat) {
        this.stat = stat;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getSrc() {
        return src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getMender() {
        return mender;
    }

    public void setMender(String mender) {
        this.mender = mender;
    }

    public String getValOld() {
        return valOld;
    }

    public void setValOld(String valOld) {
        this.valOld = valOld;
    }

    public Integer getRiskRank() {
        return riskRank;
    }

    public void setRiskRank(Integer riskRank) {
        this.riskRank = riskRank;
    }

    public String getHardWare() {
        return hardWare;
    }

    public void setHardWare(String hardWare) {
        this.hardWare = hardWare;
    }

    public String getHardWareMd5() {
        return hardWareMd5;
    }

    public void setHardWareMd5(String hardWareMd5) {
        this.hardWareMd5 = hardWareMd5;
    }

    public String getHardWareType() {
        return hardWareType;
    }

    public void setHardWareType(String hardWareType) {
        this.hardWareType = hardWareType;
    }

    public String getUdid() {
        return udid;
    }

    public void setUdid(String udid) {
        this.udid = udid;
    }
}
