package cn.com.duiba.tuia.risk.center.api.dto.domain;

import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 域名DTO
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@ToString
public class DomainDTO implements Serializable {

    private static final long serialVersionUID = 8977967840091677013L;

    /**
     * 域名记录id
     */
    private Long id;

    /**
     * 域名地址
     */
    private String domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     */
    private Integer domainType;

    /**
     * 域名状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainStatusEnum#status}
     */
    private Integer domainStatus;

    /**
     * 域名在微信的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum#status}
     */
    private Integer wxStatus;

    /**
     * 域名在支付宝的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum#status}
     */
    private Integer alipayStatus;

    /**
     * 添加人名称
     */
    private String adminName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 域名状态更新时间
     */
    private Date statusTime;

    /**
     * 微信状态更新时间
     */
    private Date wxStatusTime;

    /**
     * 支付宝状态更新时间
     */
    private Date alipayStatusTime;

    /**
     * 域名管理策略id::tb_domain_strategy.id 默认0 全局
     */
    private Long strategyId;

    /**
     * 域名被封的url
     */
    private List<String> urls;

    private String icpNo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Integer getDomainStatus() {
        return domainStatus;
    }

    public void setDomainStatus(Integer domainStatus) {
        this.domainStatus = domainStatus;
    }

    public Integer getWxStatus() {
        return wxStatus;
    }

    public void setWxStatus(Integer wxStatus) {
        this.wxStatus = wxStatus;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getStatusTime() {
        return statusTime;
    }

    public void setStatusTime(Date statusTime) {
        this.statusTime = statusTime;
    }

    public Date getWxStatusTime() {
        return wxStatusTime;
    }

    public void setWxStatusTime(Date wxStatusTime) {
        this.wxStatusTime = wxStatusTime;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public List<String> getUrls() {
        return urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public String getIcpNo() {
        return icpNo;
    }

    public void setIcpNo(String icpNo) {
        this.icpNo = icpNo;
    }
}
