package cn.com.duiba.tuia.risk.center.api.dto.req;/**
 * Created by chengdeman .
 * 18/3/1 .
 */

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 风控审核查询
 *
 * @author chengdeman
 * @create 2018-03-01 上午10:01
 **/
@ApiModel
public class ReqRiskReviewQuery extends  ReqPageQuery implements Serializable{

    private static final long serialVersionUID = -2590705433551438548L;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * APPid
     */
    private Long appId;

    /**
     * 审核人
     */
    private String riskReviewer;


	/**
	 * 实时，离线，全部 = 1，2，3
	 */
	private Integer type;

    /**
     * 作弊等级
     */
    private String cheatGrade;

    // 最终状态
    private Integer reviewResult;

    /**
     * 初步状态
     */
    private Integer preResult;

    /**
     * 媒体处理意见：1 同意 0 拒绝  -1 全部
     */
    private Integer mediaDealOpinion;

    /**
     * 处理时间：1 上午11:30 2 下午 14:00  -1 全部
     */
    private Integer dealDate;

    /**
        综合信用分   = 0
        作弊消耗   = 1
        作弊消耗占比 = 2
        作弊等级    = 3
        最终处理金额 = 4
        累计处理次数 = 5 */
    @ApiModelProperty("排序顺序 0=综合信用分 1=作弊消耗 2=作弊消耗占比 3=作弊等级 4=最终处理金额 5=累计处理次数")
    private Integer orderCondition;

    /**
     *  1 降序
     *  0 升序
     * */
    private Integer desc;

    private List<Long> slotIds;

    public String getOrderField() {
        String orderField = null;
        if (orderCondition != null) {
            switch (orderCondition) {
                case 0:
                    orderField = "credits_score";
                    break;
                case 1:
                    orderField = "cheat_fee";
                    break;
                case 2:
                    orderField = "cheat_fee_rate";
                    break;
                case 3:
                    orderField = "cheat_grade";
                    break;
                case 4:
                    orderField = "final_deal_money";
                    break;
                case 5:
                    orderField = "handleCount";
                    break;
                default:
                    orderField = "credits_score";
                    break;
            }
            if (getDesc() != null && getDesc() == 0) {
                orderField += " asc";
            } else {
                orderField += " desc";
            }
        }
        return orderField;
    }


    public Integer getPreResult() {
        return preResult;
    }

    public void setPreResult(Integer preResult) {
        this.preResult = preResult;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getRiskReviewer() {
        return riskReviewer;
    }

    public void setRiskReviewer(String riskReviewer) {
        this.riskReviewer = riskReviewer;
    }

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getCheatGrade() {
        return cheatGrade;
    }

    public void setCheatGrade(String cheatGrade) {
        this.cheatGrade = cheatGrade;
    }

    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }

    public Integer getMediaDealOpinion() {
        return mediaDealOpinion;
    }

    public void setMediaDealOpinion(Integer mediaDealOpinion) {
        this.mediaDealOpinion = mediaDealOpinion;
    }

    public Integer getDealDate() {
        return dealDate;
    }

    public void setDealDate(Integer dealDate) {
        this.dealDate = dealDate;
    }

    public Integer getOrderCondition() {
        return orderCondition;
    }

    public void setOrderCondition(Integer orderCondition) {
        this.orderCondition = orderCondition;
    }

    public Integer getDesc() {
        return desc;
    }

    public void setDesc(Integer desc) {
        this.desc = desc;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }
}