package cn.com.duiba.tuia.risk.center.api.dto.req.domain;

import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("域名解析分页查询参数")
public class DomainAnalysisParam extends ReqPageQuery {
    private static final long serialVersionUID = -6086124303945501873L;

    @ApiModelProperty("域名")
    private String domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     */
    @ApiModelProperty("域名类型，1：百奇落地页，2：积木落地页")
    private Integer domainType;

    /**
     * 解析状态 {@link cn.com.duiba.tuia.risk.center.api.enums.AnalysisStatusEnum#status}
     */
    @ApiModelProperty("解析状态，1：解析成功，0：解析失败")
    private Integer analysisStatus;

    /**
     * 失败原因类型 {@link cn.com.duiba.tuia.risk.center.api.enums.ReasonTypeEnum#status}
     */
    @ApiModelProperty("失败原因类型，1:域名解析失败,2:中台配置失败,3:验证失败")
    private Integer reasonType;

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Integer getAnalysisStatus() {
        return analysisStatus;
    }

    public void setAnalysisStatus(Integer analysisStatus) {
        this.analysisStatus = analysisStatus;
    }

    public Integer getReasonType() {
        return reasonType;
    }

    public void setReasonType(Integer reasonType) {
        this.reasonType = reasonType;
    }
}
