package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.domain.DomainStrategyDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;

import java.util.List;

/**
 * @ClassName DomainStrategyService
 * @Description 域名策略表
 * @Author lijian
 * @Date 2020/5/7 15:04
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteDomainStrategyService {

    /**
     * 域名策略 分页查询
     *
     * @param req
     * @return
     */
    PageResultDto<DomainStrategyDto> queryPage(ReqPageQuery req);

    /**
     * 保存
     * @param dto
     * @return
     */
    Integer save(DomainStrategyDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     * @param dto
     * @return
     */
    Integer updateById(DomainStrategyDto dto);

    /**
     * 按时间倒序获取所有的域名策略
     * @return
     */
    List<DomainStrategyDto> getAllStrategy();

    /**
     * 查询策略名称是否存在
     *
     * @param strategyName
     * @return
     */
    DomainStrategyDto getStrategyByStrategy(String strategyName);

}
