package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* 规则波动报警配置表
*/
@ApiModel
public class WaveAlarmConfigDto implements Serializable {

    private static final long serialVersionUID = 1616189611728953363L;

    @ApiModelProperty("唯一建")
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty("规则ID")
    private String ruleId;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型，0-A类规则 1-C类规则-实时 2-C类规则离线")
    private Integer ruleType;

    @ApiModelProperty("波动率报警上限")
    private BigDecimal alarmUp;

    @ApiModelProperty("波动率报警下限")
    private BigDecimal alarmLow;

    @ApiModelProperty("报警状态:0-关闭;1-开启")
    private Integer alarmStatus;

    @ApiModelProperty("记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty("记录修改时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setAlarmUp(BigDecimal alarmUp) {
        this.alarmUp = alarmUp;
    }

    public BigDecimal getAlarmUp() {
        return alarmUp;
    }

    public void setAlarmLow(BigDecimal alarmLow) {
        this.alarmLow = alarmLow;
    }

    public BigDecimal getAlarmLow() {
        return alarmLow;
    }

    public void setAlarmStatus(Integer alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    public Integer getAlarmStatus() {
        return alarmStatus;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

