package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 平台类型
 *
 * @author zhangbaiqiang
 * @date 2021/3/10
 */
public enum DomainPlatformEnum {

    WECHAT(1, "微信"),
    ALIPAY(2, "支付宝");

    private Integer type;
    private String desc;

    DomainPlatformEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        return Stream.of(DomainPlatformEnum.values())
                .filter(e -> Objects.equals(e.getType(), type))
                .findFirst()
                .orElse(WECHAT).desc;
    }
}
