package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.ForgeSlotCfgDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ForgeSlotCfgParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteForgeSlotCfgService {
    /**
     * 根据条件分页查询虚拟广告位配置数据
     *
     * @param param
     * @return
     */
    PageResultDto<ForgeSlotCfgDto> queryPage(ForgeSlotCfgParam param);

    /**
     * 新增虚拟广告位配置数据
     *
     * @param dto
     * @return
     */
    Integer save(ForgeSlotCfgDto dto);

    /**
     * 更新虚拟广告位配置数据
     *
     * @param dto
     * @return
     */
    Integer updateById(ForgeSlotCfgDto dto);

    /**
     * 根据条件查询虚拟广告位数据数量
     *
     * @param params
     * @return
     */
    Integer countByParam(ForgeSlotCfgParam params);

    /**
     * 获取所有启用并且广告位可投广告数>0 的配置广告位列表
     * @return
     */
    List<ForgeSlotCfgDto> getAllValidCfg();
}
