package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel
public class DimensionAnalysisParam implements Serializable {

    private static final long serialVersionUID = 300353043937963637L;

    @NotNull(message = "开始日期不能为空")
    @ApiModelProperty("开始日期, example : 2018-09-07")
    private String startTime;

    @NotNull(message = "结束日期不能为空")
    @ApiModelProperty("结束日期, example : 2018-09-07")
    private String endTime;

    @NotNull(message = "维度不能为空")
    @ApiModelProperty("支持的维度，0-ip,1-device,2-ua")
    private Integer dimension;

    @NotNull(message = "维度对应的值不能为空")
    @ApiModelProperty("维度对应的值")
    private String metric;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("媒体ID")
    private Long appId;

    @ApiModelProperty("页码")
    private Integer currentPage;

    @ApiModelProperty("页面大小")
    private Integer pageSize;

    private Integer from;

    private Integer to;

    private Integer offset;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startDate) {
        this.startTime = startDate;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endDate) {
        this.endTime = endDate;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getTo() {
        return to;
    }

    public void setTo(Integer to) {
        this.to = to;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

}
