package cn.com.duiba.tuia.risk.center.api.dto.req;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class IdAndStatus implements Serializable {

    private static final long serialVersionUID = 1L;

	@NotNull(message = "id不能为空")
	@NotEmpty
	private String id;
	@NotNull(message = "状态不能为空")
	@Range(min = 0, max = 1, message = "状态参数值不在范围内")
	@ApiModelProperty("状态")
	private Integer stat;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Integer getStat() {
		return stat;
	}

	public void setStat(Integer stat) {
		this.stat = stat;
	}
}
