package cn.com.duiba.tuia.risk.center.api.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;

/**
 * Created by Administrator on 2017/7/20.
 */
public class MathUtil {


    private MathUtil(){}

    private static final int MULTIPLIER = 100;
/**
     * @Description: yuan2Fen
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String yuan2Fen(String yuan) throws ParseException {
        NumberFormat format = NumberFormat.getInstance();
        Number number = format.parse(yuan);
        double temp = number.doubleValue() * 100.0;
        // 默认情况下GroupingUsed属性为true 不设置为false时,输出结果为2,012
        format.setGroupingUsed(false);
        // 设置返回数的小数部分所允许的最大位数
        format.setMaximumFractionDigits(0);

        return format.format(temp);
    }

    /**
     * @Description: yuan2Fen
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String yuan2Fen(int yuan) {
        NumberFormat format = NumberFormat.getInstance();
        double temp = (double) yuan * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);

        return format.format(temp);
    }

    /**
     * @Description: yuan2Fen 保留2位小数,注意传入的String是否位数字
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String fen2Yuan(String fen) {

        return new BigDecimal(fen).divide(new BigDecimal(MULTIPLIER)).setScale(2).toString();
    }

    /**
     * @Description: yuan2Fen 保留2位小数
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String fen2Yuan(int fen) {
        return new BigDecimal(fen).divide(new BigDecimal(MULTIPLIER)).setScale(2).toString();
    }

    /**
     * 计算比率，保留3位小数
     */
    public static BigDecimal calculateRate(Long divisor, Long dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.multiply(new BigDecimal(100)).divide(bigDividend, 3, BigDecimal.ROUND_HALF_UP);
        }
        return result;
    }

    /**
     * 计算比率，保留4位小数
     */
    public static BigDecimal calRate(Long divisor, Long dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4, BigDecimal.ROUND_HALF_UP);
        }
        return result;
    }

}
