package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 媒体起量监控表
 */
@ApiModel
public class MediaMonitorDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("当前日期")
    private Date curDate;

    @ApiModelProperty("应用id")
    private Long appId;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("媒体用户ID")
    private Long mediaId;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("媒体消耗（含增值）")
    private Long appConsume;

    /**
     * 媒体应得收入
     */
    private Long appIncome;

    /**
     * 现金总消耗
     */
    private Long cashConsume;

    @ApiModelProperty("现金分成比例")
    private Double cashShareRate;

    @ApiModelProperty("质量等级")
    private String estimateLevel;

    @ApiModelProperty("账号类别:  1-直客 2-代理 3代理商")
    private Integer accountType;

    @ApiModelProperty("代理商ID")
    private Long parentMediaId;

    @ApiModelProperty("黑名单等级:  1-问题账户 2-一级黑名单 3-二级黑名单 4-三级黑名单")
    private Integer blackGrade;

    @ApiModelProperty("媒介运营")
    private String mediumOperate;

    @ApiModelProperty("媒体运营")
    private String mediaOperate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("关联媒体账户ID列表")
    private List<Long> relateMediaIds;

    @ApiModelProperty("关联黑名单媒体账户ID列表")
    private List<Long> relateBlackMediaIds;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setAppConsume(Long appConsume) {
        this.appConsume = appConsume;
    }

    public Long getAppConsume() {
        return appConsume;
    }

    public void setAppIncome(Long appIncome) {
        this.appIncome = appIncome;
    }

    public Long getAppIncome() {
        return appIncome;
    }

    public void setCashConsume(Long cashConsume) {
        this.cashConsume = cashConsume;
    }

    public Long getCashConsume() {
        return cashConsume;
    }

    public void setEstimateLevel(String estimateLevel) {
        this.estimateLevel = estimateLevel;
    }

    public String getEstimateLevel() {
        return estimateLevel;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setParentMediaId(Long parentMediaId) {
        this.parentMediaId = parentMediaId;
    }

    public Long getParentMediaId() {
        return parentMediaId;
    }

    public void setMediumOperate(String mediumOperate) {
        this.mediumOperate = mediumOperate;
    }

    public String getMediumOperate() {
        return mediumOperate;
    }

    public void setMediaOperate(String mediaOperate) {
        this.mediaOperate = mediaOperate;
    }

    public String getMediaOperate() {
        return mediaOperate;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return remark;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public List<Long> getRelateMediaIds() {
        return relateMediaIds;
    }

    public void setRelateMediaIds(List<Long> relateMediaIds) {
        this.relateMediaIds = relateMediaIds;
    }

    public Double getCashShareRate() {
        return cashShareRate;
    }

    public void setCashShareRate(Double cashShareRate) {
        this.cashShareRate = cashShareRate;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public List<Long> getRelateBlackMediaIds() {
        return relateBlackMediaIds;
    }

    public void setRelateBlackMediaIds(List<Long> relateBlackMediaIds) {
        this.relateBlackMediaIds = relateBlackMediaIds;
    }

    public Integer getBlackGrade() {
        return blackGrade;
    }

    public void setBlackGrade(Integer blackGrade) {
        this.blackGrade = blackGrade;
    }
}

