package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Api("作弊流量ARPU表")
public class RiskCheatArpuDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("当天日期")
    private Date curDate;

    @ApiModelProperty("大盘消耗(分)")
    private Long totalConsume;

    @ApiModelProperty("大盘发券PV")
    private Long launchPv;

    @ApiModelProperty("C类作弊流量消耗(分)")
    private Long cCheatConsume;

    @ApiModelProperty("C类作弊流量发券PV")
    private Long cLaunchPv;

    @ApiModelProperty("A类规则量化的广告位消耗(分)")
    private Long aCheatConsume;

    @ApiModelProperty("A类规则量化的广告位总发券PV")
    private Long aLaunchPv;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("A类作弊流量ARPU")
    private BigDecimal aCheatArpu;

    @ApiModelProperty("A类ARPU差")
    private BigDecimal aArpuDiff;

    @ApiModelProperty("切量部分付费券消耗")
    private Long shearPayConsume;

    @ApiModelProperty("切量部分付费券发券pv")
    private Long shearPayLaunch;

    @ApiModelProperty("付费券发券PV")
    private Long payLaunchPv;

    @ApiModelProperty("C类作弊流量付费券发券PV")
    private Long cPayLaunchPv;


    @ApiModelProperty("大盘ARPU")
    private BigDecimal totalArpu;

    @ApiModelProperty("C类作弊流量ARPU")
    private BigDecimal cCheatArpu;

    @ApiModelProperty("C类ARPU差")
    private BigDecimal cArpuDiff;

    /**
     * 实时风控切量arpu值
     * 计算公式 = 切量部分付费券消耗 / 切量部分付费券发券pv
     */
    @ApiModelProperty("实时风控切量arpu值")
    private BigDecimal shearPayArpu;

    @ApiModelProperty("实时风控切量arpu差")
    private BigDecimal shearArpuDiff;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getTotalConsume() {
        return totalConsume;
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Long getLaunchPv() {
        return launchPv;
    }

    public void setLaunchPv(Long launchPv) {
        this.launchPv = launchPv;
    }

    public Long getcCheatConsume() {
        return cCheatConsume;
    }

    public void setcCheatConsume(Long cCheatConsume) {
        this.cCheatConsume = cCheatConsume;
    }

    public Long getcLaunchPv() {
        return cLaunchPv;
    }

    public void setcLaunchPv(Long cLaunchPv) {
        this.cLaunchPv = cLaunchPv;
    }

    public Long getaCheatConsume() {
        return aCheatConsume;
    }

    public void setaCheatConsume(Long aCheatConsume) {
        this.aCheatConsume = aCheatConsume;
    }

    public Long getaLaunchPv() {
        return aLaunchPv;
    }

    public void setaLaunchPv(Long aLaunchPv) {
        this.aLaunchPv = aLaunchPv;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public BigDecimal getTotalArpu() {
        return totalArpu;
    }

    public void setTotalArpu(BigDecimal totalArpu) {
        this.totalArpu = totalArpu;
    }

    public BigDecimal getcCheatArpu() {
        return cCheatArpu;
    }

    public void setcCheatArpu(BigDecimal cCheatArpu) {
        this.cCheatArpu = cCheatArpu;
    }

    public BigDecimal getaCheatArpu() {
        return aCheatArpu;
    }

    public void setaCheatArpu(BigDecimal aCheatArpu) {
        this.aCheatArpu = aCheatArpu;
    }

    public BigDecimal getcArpuDiff() {
        return cArpuDiff;
    }

    public void setcArpuDiff(BigDecimal cArpuDiff) {
        this.cArpuDiff = cArpuDiff;
    }

    public BigDecimal getaArpuDiff() {
        return aArpuDiff;
    }

    public void setaArpuDiff(BigDecimal aArpuDiff) {
        this.aArpuDiff = aArpuDiff;
    }

    public Long getShearPayConsume() {
        return shearPayConsume;
    }

    public void setShearPayConsume(Long shearPayConsume) {
        this.shearPayConsume = shearPayConsume;
    }

    public Long getShearPayLaunch() {
        return shearPayLaunch;
    }

    public void setShearPayLaunch(Long shearPayLaunch) {
        this.shearPayLaunch = shearPayLaunch;
    }

    public Long getPayLaunchPv() {
        return payLaunchPv;
    }

    public void setPayLaunchPv(Long payLaunchPv) {
        this.payLaunchPv = payLaunchPv;
    }

    public Long getcPayLaunchPv() {
        return cPayLaunchPv;
    }

    public void setcPayLaunchPv(Long cPayLaunchPv) {
        this.cPayLaunchPv = cPayLaunchPv;
    }

    public BigDecimal getShearPayArpu() {
        return shearPayArpu;
    }

    public void setShearPayArpu(BigDecimal shearPayArpu) {
        this.shearPayArpu = shearPayArpu;
    }

    public BigDecimal getShearArpuDiff() {
        return shearArpuDiff;
    }

    public void setShearArpuDiff(BigDecimal shearArpuDiff) {
        this.shearArpuDiff = shearArpuDiff;
    }
}

