package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 作弊广告位基础指标表
 */
public class RiskSlotTargetDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private Long id;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * APPid
     */
    private Long appId;

    /**
     * APP名称
     */
    private String appName;

    /**
     * 计费点击PV
     */
    private Long billClickPv;

    /**
     * 作弊消耗
     */
    private Long cheatFee;

    /**
     * 总消耗
     */
    private Long consume;

    /**
     * 作弊消耗占比=作弊消耗/总消耗
     */
    private BigDecimal cheatFeeRate;

    /**
     * 表单类计费点击PV
     */
    private Long formClickPv;

    /**
     * 表单类CVR=表单类落地页转化PV / 表单类计费点击PV
     */
    private BigDecimal formCvr;

    /**
     * 表单类理论CVR
     */
    private BigDecimal formTheoryCvr;

    /**
     * 表单类CVR差值=广告位表单类CVR /表单类理论CVR -1
     */
    private BigDecimal formCvrDiff;

    /**
     * API转化PV
     */
    private Long apiEffectPv;

    /**
     * API激活率
     */
    private BigDecimal apiActiveRate;

    /**
     * API理论激活率
     */
    private BigDecimal apiTheoryRate;

    /**
     * API激活率差值=该广告位启动率 / API理论激活率-1
     */
    private BigDecimal apiActiveDiff;

    /**
     * 广告位CVR
     */
    private BigDecimal cvr;

    /**
     * 理论CVR
     */
    private BigDecimal theoryCvr;

    /**
     * 广告位CVR差值=广告位CVR /理论CVR -1
     */
    private BigDecimal cvrDiff;

    /**
     * 广告位质量分
     */
    private Integer creditsScore;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 广告位落地页访问PV
     */
    private Long visitPv;

    /**
     * 广告位表单类落地页访问PV
     */
    private Long formVisitPv;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setBillClickPv(Long billClickPv) {
        this.billClickPv = billClickPv;
    }

    public Long getBillClickPv() {
        return billClickPv;
    }

    public void setCheatFee(Long cheatFee) {
        this.cheatFee = cheatFee;
    }

    public Long getCheatFee() {
        return cheatFee;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public Long getConsume() {
        return consume;
    }

    public void setCheatFeeRate(BigDecimal cheatFeeRate) {
        this.cheatFeeRate = cheatFeeRate;
    }

    public BigDecimal getCheatFeeRate() {
        return cheatFeeRate;
    }

    public void setFormClickPv(Long formClickPv) {
        this.formClickPv = formClickPv;
    }

    public Long getFormClickPv() {
        return formClickPv;
    }

    public void setFormCvr(BigDecimal formCvr) {
        this.formCvr = formCvr;
    }

    public BigDecimal getFormCvr() {
        return formCvr;
    }

    public void setFormTheoryCvr(BigDecimal formTheoryCvr) {
        this.formTheoryCvr = formTheoryCvr;
    }

    public BigDecimal getFormTheoryCvr() {
        return formTheoryCvr;
    }

    public void setFormCvrDiff(BigDecimal formCvrDiff) {
        this.formCvrDiff = formCvrDiff;
    }

    public BigDecimal getFormCvrDiff() {
        return formCvrDiff;
    }

    public void setApiEffectPv(Long apiEffectPv) {
        this.apiEffectPv = apiEffectPv;
    }

    public Long getApiEffectPv() {
        return apiEffectPv;
    }

    public void setApiActiveRate(BigDecimal apiActiveRate) {
        this.apiActiveRate = apiActiveRate;
    }

    public BigDecimal getApiActiveRate() {
        return apiActiveRate;
    }

    public void setApiTheoryRate(BigDecimal apiTheoryRate) {
        this.apiTheoryRate = apiTheoryRate;
    }

    public BigDecimal getApiTheoryRate() {
        return apiTheoryRate;
    }

    public void setApiActiveDiff(BigDecimal apiActiveDiff) {
        this.apiActiveDiff = apiActiveDiff;
    }

    public BigDecimal getApiActiveDiff() {
        return apiActiveDiff;
    }

    public void setCvr(BigDecimal cvr) {
        this.cvr = cvr;
    }

    public BigDecimal getCvr() {
        return cvr;
    }

    public void setTheoryCvr(BigDecimal theoryCvr) {
        this.theoryCvr = theoryCvr;
    }

    public BigDecimal getTheoryCvr() {
        return theoryCvr;
    }

    public void setCvrDiff(BigDecimal cvrDiff) {
        this.cvrDiff = cvrDiff;
    }

    public BigDecimal getCvrDiff() {
        return cvrDiff;
    }

    public void setCreditsScore(Integer creditsScore) {
        this.creditsScore = creditsScore;
    }

    public Integer getCreditsScore() {
        return creditsScore;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Long getVisitPv() {
        return visitPv;
    }

    public void setVisitPv(Long visitPv) {
        this.visitPv = visitPv;
    }

    public Long getFormVisitPv() {
        return formVisitPv;
    }

    public void setFormVisitPv(Long formVisitPv) {
        this.formVisitPv = formVisitPv;
    }
}

