package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
* 广告链接失效巡查日志
*/
public class UrlInvalidLogDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 
    */
    private Long id;

    /**
    * 日期
    */
    private String curDate;

    /**
    * 广告计划id
    */
    private Long advertId;

    /**
    * 广告名称
    */
    private String advertName;

    /**
    * 巡查结果：0-链接失效、1-5秒内未打开
    */
    private Integer patrolResult;

    /**
     * 截图URL
     */
    private String imgUrl;

    /**
    * 巡查时间
    */
    private Date patrolTime;

    /**
    * AE：该广告计划对应的AE
    */
    private String aeName;

    /**
    * 销售：该广告计划对应的销售
    */
    private String saleName;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 落地页url
     */
    private String promoteUrl;

    /**
     * 打开链接时间
     */
    private Integer loadTime;

    /**
     * url类型:0-落地页;1-二次跳转页面;2-配置落地页;3-ABTest落地页;4-素材绑定落地页;5-新媒体落地页
     */
    private Integer urlType;

    /**
     * 落地页ID
     */
    private Long landPageId;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setPatrolResult(Integer patrolResult) {
        this.patrolResult = patrolResult;
    }

    public Integer getPatrolResult() {
        return patrolResult;
    }

    public void setPatrolTime(Date patrolTime) {
        this.patrolTime = patrolTime;
    }

    public Date getPatrolTime() {
        return patrolTime;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getAeName() {
        return aeName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }

    public String getSaleName() {
        return saleName;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public Integer getLoadTime() {
        return loadTime;
    }

    public void setLoadTime(Integer loadTime) {
        this.loadTime = loadTime;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public Long getLandPageId() {
        return landPageId;
    }

    public void setLandPageId(Long landPageId) {
        this.landPageId = landPageId;
    }
}

