package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 失败原因类型
 *
 * @author lijian
 * @date 2019/12/02
 * @since JDK 1.8
 */
public enum ReasonTypeEnum {

    DOMAIN_FALSE(1, "域名解析失败"),
    CONFIG_FALSE(2, "中台配置失败"),
    CHECK_FALSE(3, "验证失败");

    /**
     * 状态值
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    ReasonTypeEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return
     */
    public static ReasonTypeEnum findByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return Stream.of(ReasonTypeEnum.values()).filter(e -> Objects.equals(e.getStatus(), status)).findFirst().orElse(null);
    }
}
