package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.AccountQuarterScoreDto;

/**
 * 广告主季度违规处罚积分表
 */
@AdvancedFeignClient
public interface RemoteAccountQuarterScoreService {

    /**
     * 保存
     *
     * @param dto
     * @return
     */
    Integer save(AccountQuarterScoreDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(AccountQuarterScoreDto dto);

    /**
     * 根据 季度和广告主ID获取广告主处罚分信息
     *
     * @param tbQuarter
     * @param accountId
     * @return
     */
    AccountQuarterScoreDto getInfoByQuarterAndAccount(String tbQuarter, Long accountId);


}
