package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageDto;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetDto;
import cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetTimeDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqAppAdvertBudgetParam;

import java.util.List;

/**
 * @author fanjia
 * @date 2021年06月10日 上午10:48
 */
@AdvancedFeignClient
public interface RemoteAppAdvertBudgetService {

    /**
     * 查询行业接口
     *
     * @param sourceType 数据类型
     * @return java.util.List<java.lang.String>
     * @author fanjia
     * @date 2021/6/10 下午2:35
     */
    List<String> industryList(Integer sourceType);


    /**
     * 查询分类/领域接口接口
     *
     * @param sourceType 数据类型
     * @return java.util.List<java.lang.String>
     * @author fanjia
     * @date 2021/6/10 下午2:35
     */
    List<String> territoryClassifyList(Integer sourceType);

    /**
     * 查询最大最小时间
     *
     * @param sourceType 数据类型
     * @return cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetTimeDto
     * @author fanjia
     * @date 2021/6/10 下午2:35
     */
    AppAdvertBudgetTimeDto getTime(Integer sourceType);

    /**
     * 查询当前时间下 改数据类型的所有数据
     *
     * @param sourceType 数据类型
     * @param climbTime  时间
     * @return java.util.List<cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetDto>
     * @author fanjia
     * @date 2021/6/10 下午2:36
     */
    List<AppAdvertBudgetDto> appAdvertBudgetListBySourceTypeAndClimbTime(Integer sourceType, String climbTime);

    /**
     * 分页条件查询
     *
     * @param param
     * @return cn.com.duiba.tuia.risk.center.api.common.PageResultDto<cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetDto>
     * @author fanjia
     * @date 2021/6/10 下午2:36
     */
    PageResultDto<AppAdvertBudgetDto> pageAppAdvertBudgetList(ReqAppAdvertBudgetParam param);




    List<AppAdvertBudgetDto> listAppAdvertBudget(ReqAppAdvertBudgetParam param);


    /**  统计广告行业预算监控-
     *
     * @author fanjia
     * @date 2021/6/18 下午5:06
     * @param param.nowTime  要查询的日子 2021-06
     * @param lastTime  上一个时间的妻子
     * @param orderByType 排序类型3和4
     * @return java.util.List<cn.com.duiba.tuia.risk.center.api.dto.AppAdvertBudgetDto>
     */
    PageResultDto<AppAdvertBudgetDto> pageCountByindustryWhereSourceTypeIsthree(ReqAppAdvertBudgetParam param);

    List<AppAdvertBudgetDto>  countByindustryWhereSourceTypeIsthree (ReqAppAdvertBudgetParam param);

}
