package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AuditRejectTemplateInfoDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.AuditRejectTemplateParam;

import java.util.List;

/**
 * 处罚积分审核拒绝模板表
 */
@AdvancedFeignClient
public interface RemoteAuditRejectTemplateInfoService {

    /**
     * 保存
     * @param dto
     * @return
     */
    Integer save(AuditRejectTemplateInfoDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     * @param dto
     * @return
     */
    Integer updateById(AuditRejectTemplateInfoDto dto);

    /**
     * 分页查询
     * @param param
     * @return
     */
    PageResultDto<AuditRejectTemplateInfoDto> queryPage(AuditRejectTemplateParam param);

    /**
     * 获取所有的场景列表
     * @return
     */
    List<String> getAllScenes();

    /**
     * 根据场景查询违规等级
     * @param sceneName
     * @return
     */
    List<Integer> getGradeByScene(String sceneName);

    /**
     * 根据场景和违规等级查询违规描述数据
     * @param sceneName
     * @param gradeType
     * @return
     */
    List<AuditRejectTemplateInfoDto> getBySceneAndGrade(String sceneName, Integer gradeType);

    /**
     * 唯一性校验：场景，违规类型，违规描述唯一
     * @param dto
     * @return
     */
    AuditRejectTemplateInfoDto checkUnique(AuditRejectTemplateInfoDto dto);

}
