package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompeteDomainPatrolDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompeteDomainPatrolParam;
import cn.com.duiba.tuia.risk.center.api.dto.RiskMaterialSignDto;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteCompeteDomainPatrolService {

    PageResultDto<CompeteDomainPatrolDto> queryPage(CompeteDomainPatrolParam param);

    int save(CompeteDomainPatrolDto dto);

    int update(CompeteDomainPatrolDto dto);

    int deleteById(Long id);
    /** 批量更新该数据的最近一次定时任务执行时间 和执行的状态
     *
     * @author fanjia
     * @date 2021/8/11 下午2:54
     * @param idList
     * @param lastExecuteTime
     * @param lastExecuteState
     * @return int
     */
    int updateLastExecuteStateAndTimeByIds(List<Long> idList, Date lastExecuteTime,  Integer lastExecuteState);
    /**
     * 获取已保存的竞品名称列表
     */
    List<String> getAllCompeteNames();

    /**
     * 获取已保存的媒体名称列表
     */
    List<String> getAllMediaNames();

    /**
     * 情报系统竞品域名巡查任务
     */
    void competeDomainPatrolProcess();

    CompeteDomainPatrolDto getById(Long id);

    /**
     * 竞品巡查日志,行业标签巡检
     */
    void dealTagReview(Long competeId);

    /**
     * 根据竞品名称查询关联的媒体名称列表
     */
    List<String> getMediaNameByCompeteName(String competeName);

    /**
     * 根据竞品名称，媒体列表查询竞品id列表
     */
    List<Long> getCompeteIdListByCompeteAndMedia(String competeName, List<String> mediaList);


    /**
     * 根据id列表查询竞品信息
     * @param competeIds
     * @return
     */
    List<CompeteDomainPatrolDto> getListByIds(List<Long> competeIds);

    /**
     * 手动标签标记行业，同一竞品下的落地页链接标签保持一致
     */
    void dealTagSign(RiskMaterialSignDto param);
}
