package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.domain.DomainAlarmDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.PagingAlarmParam;

/**
 * 域名告警服务
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDomainAlarmService {

    /**
     * 告警分页查询
     *
     * @param pagingAlarmParam  查询参数
     * @return
     */
    PageResultDto<DomainAlarmDTO> pagingList(PagingAlarmParam pagingAlarmParam);

    /**
     * 保存告警
     *
     * @param alarmDTO      告警参数
     * @throws  cn.com.duiba.boot.exception.BizException
     * @return
     */
    Boolean saveAlarm(DomainAlarmDTO alarmDTO) throws BizException;

    /**
     * 删除域名
     *
     * @param  id   域名告警id
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    Boolean deleteAlarm(Long id) throws BizException;
}
