package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.BlacklistDto;
import cn.com.duiba.tuia.risk.center.api.dto.IdStatTimeMender;
import cn.com.duiba.tuia.risk.center.api.dto.req.BlacklistSearchParam;

import java.util.Collection;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteBlacklistService {
	PageResultDto<BlacklistDto> queryPage(BlacklistSearchParam param);
	long save(BlacklistDto dto);
	int update(BlacklistDto dto);
	List<BlacklistDto> listByIds(List<Long> ids);
	int updateStat(IdStatTimeMender dto);
	int count(BlacklistDto dto);
	BlacklistDto getById(Long id);
	List<BlacklistDto> query4Page(int from, int to);
	int bulkInsert(Collection<BlacklistDto> dtos);

	Integer getMaxId();

	List<BlacklistDto> query4PageById(int from, int to);


	Boolean updateUniqueCheck(BlacklistDto dto);
}
