/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);

    private HttpClientUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String requestByGet(String url, int timeout) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
            httpget.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() != 200) return null;
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("http get error", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String requestByPost(String url, String request, int timeout) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
            httppost.setConfig(requestConfig);
            httppost.setEntity((HttpEntity)new StringEntity(request, "UTF-8"));
            httppost.setHeader("Content-Type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httppost);
            if (response.getStatusLine().getStatusCode() != 200) return null;
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            log.error("http post error", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String requestByPost(String url, Map<String, Object> param) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
            httppost.setConfig(requestConfig);
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.getPostParam(param), "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httppost);
            if (response.getStatusLine().getStatusCode() != 200) return null;
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (IOException e) {
            log.error("http post error", (Throwable)e);
        }
        return null;
    }

    private static List<NameValuePair> getPostParam(Map<String, Object> map) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        return nameValuePairs;
    }
}

