package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskSlotTargetDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.RiskSlotTargetParam;

import java.util.List;
@AdvancedFeignClient
public interface RemoteRiskSlotTargetService {

    /**
     * 根据日期和广告位列表查询综合信用分信息
     *
     * @param param
     * @return
     */
    List<RiskSlotTargetDto> listBySlotIds(RiskSlotTargetParam param);

    /**
     * 根据条件分页查询指标信息
     *
     * @param param
     * @return
     */
    PageResultDto<RiskSlotTargetDto> queryPage(RiskSlotTargetParam param);

    /**
     * 更新综合信用分信息
     *
     * @param riskSlotTargetDto
     * @return
     */
    Integer updateById(RiskSlotTargetDto riskSlotTargetDto);

    /**
     * 批量更新综合信用分信息
     *
     * @param list
     * @return
     */
    Integer updateByBatch(List<RiskSlotTargetDto> list);

    Integer deleteByParam(String curDate);
}
