package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RuleWaveAnalysisRsp;
import cn.com.duiba.tuia.risk.center.api.dto.WaveAnalysisRsp;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqSlotWaveAnalysis;

import java.util.List;
import java.util.concurrent.ExecutionException;

@AdvancedFeignClient
public interface RemoteSlotWaveAnalysisService {

    /**
     * 规则波动分析查询
     * @param req
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    PageResultDto<WaveAnalysisRsp> query4PageByRuleId(ReqSlotWaveAnalysis req) throws ExecutionException, InterruptedException;

    PageResultDto<WaveAnalysisRsp> query4PageBySlotAndRule(ReqSlotWaveAnalysis req) throws ExecutionException, InterruptedException;

    PageResultDto<WaveAnalysisRsp> query4PageBySlot(ReqSlotWaveAnalysis req) throws ExecutionException, InterruptedException;

    /**
     * 规则汇总数据查询
     * @param req
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    WaveAnalysisRsp getSummary(ReqSlotWaveAnalysis req) throws ExecutionException, InterruptedException;


    /**
     * C类离线规则波动分析接口
     * @param req
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    List<RuleWaveAnalysisRsp> getCOffLineAnalysis(ReqSlotWaveAnalysis req) throws ExecutionException, InterruptedException;
}
