package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class RiskSlotReviewRecordDto implements Serializable {

    private static final long serialVersionUID = 92059235613198519L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("审核时间")
    private Date reviewTime;

    @ApiModelProperty("广告名字")
    private String advertName;

    @ApiModelProperty("资源审核状态 1-拒绝 2-通过")
    private Integer reviewStatus;

    @ApiModelProperty("资源的url")
    private String resourceUrl;

    @ApiModelProperty("敏感词")
    private String violationWords;

    @ApiModelProperty("url类型 0-落地页 1-二次跳转页面")
    private Integer urlType;

    @ApiModelProperty("url")
    private String landingUrl;

    @ApiModelProperty("审核理由")
    private String reviewReason;

    @ApiModelProperty("审核人")
    private String reviewer;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("提交时间")
    private Date commitTime;

    @ApiModelProperty("广告主id")
    private Long accountId;

    @ApiModelProperty("广告主名称")
    private String advertMaster;

    @ApiModelProperty("代理商")
    private String agent;

    @ApiModelProperty("广告主篡改次数")
    private Integer distortCount;

    @ApiModelProperty("当日消耗")
    private Long consume;

    @ApiModelProperty("篡改类型 0-证券行业严重篡改,1-非证券行业严重篡改,2-非证券行业普通篡改")
    private Integer distortType;

    @ApiModelProperty("申诉状态：0-未申诉、1-申诉成功、2-申诉失败")
    private Integer appealStatus;

    //当前季度开始时间
    private String quarterBeginTime;

    //AE 钉钉id  用于钉钉提醒
    private String aeDingId;
    //销售 钉钉id  用于钉钉提醒
    private String saleDingId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getReviewReason() {
        return reviewReason;
    }

    public void setReviewReason(String reviewReason) {
        this.reviewReason = reviewReason;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Date commitTime) {
        this.commitTime = commitTime;
    }

    public void setViolationWords(String violationWords) {
        this.violationWords = violationWords;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public String getLandingUrl() {
        return landingUrl;
    }

    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    public String getViolationWords() {
        return violationWords;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAdvertMaster() {
        return advertMaster;
    }

    public void setAdvertMaster(String advertMaster) {
        this.advertMaster = advertMaster;
    }

    public String getAgent() {
        return agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public Integer getDistortCount() {
        return distortCount;
    }

    public void setDistortCount(Integer distortCount) {
        this.distortCount = distortCount;
    }

    public Long getConsume() {
        return consume;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public Integer getDistortType() {
        return distortType;
    }

    public void setDistortType(Integer distortType) {
        this.distortType = distortType;
    }

    public String getAeDingId() {
        return aeDingId;
    }

    public void setAeDingId(String aeDingId) {
        this.aeDingId = aeDingId;
    }

    public String getSaleDingId() {
        return saleDingId;
    }

    public void setSaleDingId(String saleDingId) {
        this.saleDingId = saleDingId;
    }

    public Integer getAppealStatus() {
        return appealStatus;
    }

    public void setAppealStatus(Integer appealStatus) {
        this.appealStatus = appealStatus;
    }

    public String getQuarterBeginTime() {
        return quarterBeginTime;
    }

    public void setQuarterBeginTime(String quarterBeginTime) {
        this.quarterBeginTime = quarterBeginTime;
    }
}
