package cn.com.duiba.tuia.risk.center.api.dto.req.domain;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2021-06-11
 */
@Data
public class DomainQueryDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 域名地址
     */
    private String      domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum}
     */
    private Integer     domainType;

    /**
     * 域名状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainStatusEnum}
     */
    private Integer     domainStatus;

    /**
     * 域名在微信的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum}
     */
    private Integer     wxStatus;

    /**
     * 域名在支付宝的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum}
     */
    private Integer     alipayStatus;

    /**
     * 域名管理策略id::tb_domain_strategy.id 默认0 全局
     */
    private Long strategyId;

    /**新行业标签 -1:不限*/
    private String newTrade;

    /**域名在支付宝IOS的投放状态*/
    private Integer alipayIosStatus;
}
