package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.DomainAndCertificateDTO;
import cn.com.duiba.tuia.risk.center.api.dto.domain.DomainDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.DomainBlockedDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.DomainDealParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.DomainNotifyDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.DomainQueryDTO;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.PagingDomainParam;

import java.util.List;
import java.util.Set;

/**
 * 域名服务
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteDomainService {

    /**
     * 域名分页查询
     *
     * @param pagingDomainParam  查询参数
     * @return
     */
    PageResultDto<DomainDTO> pagingList(PagingDomainParam pagingDomainParam);

    /**
     * 添加域名 会进行http校验(原来的老接口逻辑)
     *
     * @param domainDTO      域名参数
     * @throws  BizException
     * @return
     */
    boolean addDomain(DomainDTO domainDTO) throws BizException;

    /**
     * 添加域名 状态设置为有效
     *
     * @param domainDTO      域名参数
     * @throws  BizException
     * @return
     */
    boolean addDomainStateVaild(DomainDTO domainDTO) throws BizException;

    /**
     * 更新域名
     *
     * @param domainDTO      域名参数
     * @throws  BizException
     * @return
     */
    boolean updateDomain(DomainDTO domainDTO) throws BizException;

    /**
     * 更新域名状态
     *
     * @param domainDTO      域名参数
     * @throws  BizException
     * @return
     */
    boolean updateDomainStatus(DomainDTO domainDTO) throws BizException;

    /**
     * 删除域名
     *
     * @param  id   域名记录id
     * @return
     * @throws BizException
     */
    boolean deleteDomain(Long id) throws BizException;

    /**
     * 根据域名类型查询有效域名列表
     *
     * @param domainType  域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    List<String> selectValidDomainByType(Integer domainType);

    /**
     * 根据域名类型查询有效且支付宝可用的域名列表
     *
     * @param domainType  域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    List<String> selectAlipayValidDomainByType(Integer domainType);

    /**
     * 查询给微信巡查的域名列表
     *
     * @return
     */
    List<String> selectWxPatrol();

    /**
     * 根据域名查询
     *
     * @param domain   域名
     * @return
     */
    DomainDTO selectByDomain(String domain);

    /**
     * 根据策略id 和域名类型查询替换域名
     * @param advertId   广告id
     * @param domainType 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    String getReplaceDomain(Long advertId, Integer domainType);

    /**
     * 根据域名类型查询有效域名列表
     *
     * @param domainType  域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    List<DomainDTO> getValidDomainByType(Integer domainType);

    /**
     * 根据域名类型查询有效且支付宝可用的域名列表
     *
     * @param domainType  域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     * @return
     */
    List<DomainDTO> getAlipayValidDomainByType(Integer domainType);

    /**
     * 查询有效域名列表
     * @param queryDTO
     * @return
     */
    List<DomainDTO> listValidDomain(DomainQueryDTO queryDTO);

    /**
     * 处理被封域名
     * @param blockedDTO
     * @return
     */
    int handleBlockedDomain(DomainBlockedDTO blockedDTO);

    /**
     * 根据域名策略更新域名到新的策略
     * @param strategyId
     * @param newStrategyId
     * @return
     */
    Integer updateDomainStrategy(Long strategyId, Long newStrategyId);

    /**
     * 根据域名获取数据
     * @param domains
     * @return
     */
    List<DomainDTO> getByDomains(List<String> domains);

    /**
     * 根据域名获取失效的域名列表
     *
     * @param domainDealParam
     * @return
     */
    Set<String> getInvalidDomainParam(DomainDealParam domainDealParam);

    /**
     * 根据域名查询icp备案号
     *
     * @param domain
     * @return
     */
    String getIcpNoByDomain(String domain);

    /**
     * 获取有效域名列表
     * @return
     */
    List<DomainDTO> getDomains();

    /**
     * 初始化icp备案号信息
     */
    void initIcpInfo();

    /**
     * 星盟台域名异常通知接口
     *
     * @param domainNotify
     * @return
     */
    boolean notifyDomainStatus(DomainNotifyDTO domainNotify);

    /**
     * 同步星盟台域名的状态
     * @param id
     * @return
     */
    int syncDomainStatus(Long id);

    /**
     * 查找：域名类型为小程序中间域名 且 域名状态正常 且 未删除 的域名
     * @return
     */
    List<DomainAndCertificateDTO> findValidDomain();
}
